﻿<%@ Control Language="C#" AutoEventWireup="true" CodeFile="SSNAndFacilitySelect2.ascx.cs" Inherits="SSNAndFacilitySelect2" %>
<%@ Register assembly="RJS.Web.WebControl.PopCalendar.Net.2008" namespace="RJS.Web.WebControl" tagprefix="rjs" %>

<asp:ScriptManager ID="ScriptManager1" runat="server">
</asp:ScriptManager>
            <asp:Label ID="LabelSocialSecurityNumber" runat="server" 
                Text="Social Security Number (XXX-XX-XXXX) *:" 
                Font-Bold="true" 
                AssociatedControlID="TxtBoxSnum">
            </asp:Label>
            <br />
            <asp:TextBox ID="TxtBoxSnum" runat="server" 
                    AutoPostBack="false"  
                    TabIndex="5"
                    MaxLength="12">
                </asp:TextBox>&nbsp;
            <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" 
                ControlToValidate="TxtBoxSnum"
                ValidationGroup="RunReport" 
                EnableClientScript="true"  
                SetFocusOnError="true"
                ErrorMessage="SSN is required."
                Display="Static">
            </asp:RequiredFieldValidator>
            <asp:RegularExpressionValidator ID="RegularExpressionValidator1" runat="server" 
                    TabIndex="6"
                    ValidationGroup="RunReport" 
                    EnableClientScript="true"
                    Display="Dynamic"  
                    SetFocusOnError="true"
                    ValidationExpression="^\s*\d{3}-?\d{2}-?\d{4}[pP]?\s*$"
                    ControlToValidate="TxtBoxSnum" 
                    ErrorMessage="SSN needs to be in the following format (dashes optional): XXX-XX-XXXX.  Include a 'P' or 'p' at the end for pseudo SSN’s."> 
            </asp:RegularExpressionValidator>
       <br /><br />
            <asp:Label ID="LabelVisn" runat="server" Text="VISN *:" Font-Bold="true" AssociatedControlID="DropDownListVisnID"></asp:Label>
            <br />
            <asp:DropDownList ID="DropDownListVisnID" runat="server" 
                TabIndex="7"
                AutoPostBack="True"
                DataTextField="visnName" DataValueField="visnId" 
                onselectedindexchanged="DropDownListVisnID_SelectedIndexChanged">
                <asp:ListItem Value="NoneSelected">Select One</asp:ListItem>
                <asp:ListItem Value="V01">VISN 1</asp:ListItem>
                <asp:ListItem Value="V02">VISN 2</asp:ListItem>
                <asp:ListItem Value="V03">VISN 3</asp:ListItem>
                <asp:ListItem Value="V04">VISN 4</asp:ListItem>
                <asp:ListItem Value="V05">VISN 5</asp:ListItem>
                <asp:ListItem Value="V06">VISN 6</asp:ListItem>
                <asp:ListItem Value="V07">VISN 7</asp:ListItem>
                <asp:ListItem Value="V08">VISN 8</asp:ListItem>
                <asp:ListItem Value="V09">VISN 9</asp:ListItem>
                <asp:ListItem Value="V10">VISN 10</asp:ListItem>
                <asp:ListItem Value="V11">VISN 11</asp:ListItem>
                <asp:ListItem Value="V12">VISN 12</asp:ListItem>
                
                
                <asp:ListItem Value="V15">VISN 15</asp:ListItem>
                <asp:ListItem Value="V16">VISN 16</asp:ListItem>
                <asp:ListItem Value="V17">VISN 17</asp:ListItem>
                <asp:ListItem Value="V18">VISN 18</asp:ListItem>
                <asp:ListItem Value="v19">VISN 19</asp:ListItem>
                <asp:ListItem Value="V20">VISN 20</asp:ListItem>
                <asp:ListItem Value="V21">VISN 21</asp:ListItem>
                <asp:ListItem Value="V22">VISN 22</asp:ListItem>
                <asp:ListItem Value="V23">VISN 23</asp:ListItem>
            </asp:DropDownList>&nbsp;
            <asp:RequiredFieldValidator ID="RequiredFieldValidatorForDropDownListVisnID" runat="server" 
                    ControlToValidate="DropDownListVisnID"
                    ValidationGroup="RunReport" 
                    EnableClientScript="true"  
                    SetFocusOnError="true"
                    ErrorMessage="VISN is required."
                    Display="Static"
                    InitialValue="NoneSelected"></asp:RequiredFieldValidator>
<br /><br />
            <asp:Label ID="LabelStation" runat="server" Text="Facility *:" Font-Bold="true" AssociatedControlID="DropDownListFacility"></asp:Label>
            <br />
             <asp:DropDownList ID="DropDownListFacility" runat="server" 
                TabIndex="8"
                AutoPostBack="True" 
                DataTextField="Name" 
                DataValueField="station_number" 
                Width="669px">
            </asp:DropDownList>&nbsp;
            <br /><asp:RequiredFieldValidator ID="RequiredFieldValidatorDropDownListFacility" runat="server" 
                    ControlToValidate="DropDownListFacility"
                    ValidationGroup="RunReport" 
                    EnableClientScript="true"  
                    SetFocusOnError="true"
                    ErrorMessage="Facility is required."
                    Display="Static"
                    InitialValue="000">
            </asp:RequiredFieldValidator>


<asp:ObjectDataSource ID="ObjectDataSourcePermittedStationVISNs" runat="server" 
    OldValuesParameterFormatString="original_{0}" SelectMethod="GetData" 
     TypeName="ReportUserAccessTableAdapters.TBI_GetPermittedStationVISNsTableAdapter" 
     onselecting="ObjectDataSourcePermittedVISNs_Selecting">
    <SelectParameters>
        <asp:Parameter Name="userName" Type="String" />
    </SelectParameters>
</asp:ObjectDataSource>
<asp:ObjectDataSource ID="ObjectDataSourcePermittedStations" runat="server" 
    OldValuesParameterFormatString="original_{0}" SelectMethod="GetData" 
    onselecting="ObjectDataSourcePermittedStations_Selecting" TypeName="ReportUserAccessTableAdapters.TBI_GetDirectliAndIndirectlyPermittedStationsTableAdapter" 
     >
    <SelectParameters>
        <asp:ControlParameter ControlID="DropDownListVisnID" Name="visnId" 
            PropertyName="SelectedValue" Type="String" />
        <asp:Parameter Name="userName" Type="String" />
    </SelectParameters>
</asp:ObjectDataSource>
<!-- 
    The SQL command string has been replaced in the SQLDataSource1 definition below, specifically, "base_station_number" in the ORDER BY clause 
    has been replaced by "station_number" in for the Facility drop down to sort properly when executing certain reports,
    
    SelectCommand="SELECT * FROM [viewFacilitiesByVisn] v where visnId = @visnId and v.Name is not null order by VisNum, base_station_number, institution_id">
    
    JPS 08-Jun-2010
-->
<asp:SqlDataSource ID="SqlDataSource1" runat="server" 
     ConnectionString="<%$ ConnectionStrings:RegistryConnectionString %>" 
     SelectCommand="SELECT * FROM [viewFacilitiesByVisn] v where visnId = @visnId and v.Name is not null order by VisNum, station_number, institution_id">
        <SelectParameters>
            <asp:ControlParameter ControlID="DropDownListVisnID" Name="visnId" 
                PropertyName="SelectedValue" />
        </SelectParameters>
</asp:SqlDataSource>
              














